#pragma semicolon 1
#include <sourcemod>

#define SPECTATOR_TEAM 1
#define TERRORIST_TEAM 2
#define COUNTER_TERRORIST_TEAM 3
#define DL_VERSION "1.0.0"
#define DL_DESCRIPTION "A service developed by Twelve-60 of GotGames (www.gotgames.com.au) to block anti-competitive configurations"

new gMaxClients;

public Plugin:myinfo = {
	name = "GotGames DeadLock",
	author = "Twelve-60",
	description = DL_DESCRIPTION,
	version = DL_VERSION,
	url = "http://www.gotgames.com.au"
};

public OnPluginStart() {
	LoadTranslations("deadlock.phrases");
	
	RegConsoleCmd("dl_version", DLVersion);
	CreateConVar("dl_notify_version", DL_VERSION, DL_DESCRIPTION, FCVAR_CHEAT|FCVAR_NOTIFY|FCVAR_REPLICATED);
	
	HookEvent("round_start",  Event_Round_Start);
	HookEvent("player_team",  Event_Player_Team);
}

public OnMapStart() {
    gMaxClients = GetMaxClients();
}

public OnClientPutInServer(client) {
	if (!IsFakeClient(client)) {
		CheckPlayer(client);
	}
}

public Event_Round_Start(Handle:event, const String:name[], bool:dontBroadcast) {
	CreateTimer(0.1, CheckPlayers);
	CreateTimer(GetRandomFloat(5.0, 100.0), CheckPlayers);
}

public Event_Player_Team(Handle:event, const String:name[], bool:dontBroadcast) {
	CreateTimer(3.0, ShowPluginInfo, GetClientOfUserId(GetEventInt(event, "userid")));
}

public Action:CheckPlayers(Handle:timer) {
	for (new i = 1; i <= gMaxClients; i++) {
		if (IsClientConnected(i) && IsClientInGame(i) && !IsFakeClient(i)) {
			CheckPlayer(i);
		}
	}
}

CheckPlayer(client) {
	QueryClientConVar(client, "net_graph", ClientCVarCallback, client);
}

public ClientCVarCallback(QueryCookie:cookie, client, ConVarQueryResult:result, const String:cvarName[], const String:cvarValue[], any:admin2) {
	if (result == ConVarQuery_Okay) {
		if (StrEqual(cvarName, "net_graph")) {
			if (!StrEqual(cvarValue, "0") && !StrEqual(cvarValue, "1") && !StrEqual(cvarValue, "3")) {
				new String:playerName[32];
				new String:logString[128];
				CS_GetLogString(client, logString, sizeof(logString));
				GetClientName(client, playerName, sizeof(playerName));
				KickClient(client, "%t", "NetGraph", cvarName, cvarName);
				PrintToChatAll("\x03<DeadLock> \x04%t", "Kicked", playerName, cvarName);
				Log2Game("kicked\" (player \"%s\") (cvar \"%s\") (value \"%s\")", logString, cvarName, cvarValue);
			}
		}
	}
}

public Action:ShowPluginInfo(Handle:timer, any:client) {
	if (client != 0 && IsClientConnected(client) && IsClientInGame(client)) {
		PrintToConsole(client, "==============================================================");
		PrintToConsole(client, "This server is protected by GotGames DeadLock %s Server Plugin", DL_VERSION);
		PrintToConsole(client, "");
		PrintToConsole(client, "Created by Twelve-60 of GotGames (www.gotgames.com.au), original concept by JoolzCheat");
		PrintToConsole(client, "");
		PrintToConsole(client, "==============================================================");
	}
}

public Action:DLVersion(client, args) {
	if (client == 0)
		PrintToServer("\"dl_version\" = \"%s\"\n - <DeadLock> %s", DL_VERSION, DL_DESCRIPTION);
	else
		PrintToConsole(client, "\"dl_version\" = \"%s\"\n - <DeadLock> %s", DL_VERSION, DL_DESCRIPTION);

	return Plugin_Handled;
}

Log2Game(const String:Format[], any:...) {
	decl String:buffer[1024];
	VFormat(buffer, sizeof(buffer), Format, 2);
	LogToGame("DeadLock triggered %s", buffer);
}

stock CS_GetLogString(client, String:LogString[], size) {
	if (!IsClientInGame(client))
		return -1;

	new String:player_name[32];
	new userid;
	new String:authid[32];
	new String:team[32];
	
	GetClientName(client, player_name, sizeof(player_name));
	GetClientAuthString(client, authid, sizeof(authid));
	userid = GetClientUserId(client);
	
	if (GetClientTeam(client) == TERRORIST_TEAM)
		team = "TERRORIST";
	else if(GetClientTeam(client) == COUNTER_TERRORIST_TEAM)
		team = "CT";
	else if(GetClientTeam(client) == SPECTATOR_TEAM)
		team = "Spectator";
	
	Format(LogString, size, "%s<%d><%s><%s>", player_name, userid, authid, team);

	return client;
}