﻿admins = ['STEAM_ID_LAN', 'STEAM_0:1:1930621483', 'Another...', 'AND SO ON']
use_mani_auth = 0 #change this to 1 to get auth from mani's clients.txt

import es, popuplib, os, gamethread, services

info = es.AddonInfo()
info.name     = "Addon Manager"
info.version  = "1.5"
info.url      = "http://forums.mattie.info/cs/forums/viewtopic.php?p=257533"
info.basename = "addon_manager"
info.author   = "DanielB"
es.ServerVar('addon_manager_ver', info.version, 'What version of Addon manager is running').makepublic()

addons = {}
ignore = ['benchmark', 'corelib', 'crontab', 'diag', 'examples', 'itemmem', 'keymenu', 'popup', 'pybenchmark', 'pyunittest', 'schedule', 'setting', 'unittest', 'vote']
popup = 0
submenu = None
es_dir = es.ServerVar('eventscripts_gamedir') + '/addons/eventscripts/'
isAuthed = None

def msg(text):
    es.msg('#multi', '#green[Addon Manager]#lightgreen ' + text)
    
def load():
    parseAddons()
    if not es.exists('command', 'addon_manager'):
        es.regcmd('addon_manager', 'addon_manager/ess_manage', 'Used to add Addon_manager support or ESS scripts syntax: addon_manager <basename> <addon name> <author> <version>')
    if not es.exists('saycommand', '!addons'):
        es.regsaycmd('!addons', 'addon_manager/sendMenu', 'Show Addon manager Menu')
    if not es.exists('command', 'am_load'):
        es.regcmd('am_load', 'addon_manager/am_load', 'Load scripts and set information: am_load <basename> <addon name> <author> <version>')
    setup_auth()
    if use_mani_auth: mani_auth()
    msg('Версия %s.Мод включен...'%info.version)

def ess_manage():
    global addons
    basename = es.getargv(1)
    name = es.getargv(2)
    author = es.getargv(3)
    version = es.getargv(4)
    if bool(basename) and bool(name) and bool(author) and bool(version):
        if addons.has_key(basename):
            addons[basename].name = name
            addons[basename].author = author
            addons[basename].version = version
            genPopup()
        else:
            es.dbgmsg(0, 'Addon "%s" does not appear to exist')
    else:
        es.dbgmsg(0, 'Invalid Syntax or Invalid number of args')
        es.dbgmsg(0, 'Syntax: addon_manager <basename> <addon name> <author> <version>')

def unload():
    msg('Выключен...')
    es.unregsaycmd('!addons')

def mani_auth():
    clientsPath = str(es.ServerVar('eventscripts_gamedir')) + '/cfg/mani_admin_plugin/clients.txt'
    clientsFile = open(clientsPath, 'r')
    for line in clientsFile:
        list_line = line.split('"')
        if len(list_line) > 3:
            if list_line[3].startswith('STEAM_'):
                admins.append(list_line[3])
    clientsFile.flush()
    clientsFile.close() 

def parseAddons():
    global addons
    
    files = os.listdir(es_dir)
    addon_paths = []
    for i in files:
        if i[:1] != '_':
            if os.path.isdir(es_dir+i):
                if not i in ignore:
                    addon_paths.append(i)

    for i in addon_paths:
        files = os.listdir(es_dir+i)
        if 'es_'+i+'.txt' in files:
            addons[i] = addon('txt', 'Неизвестно', i, i, 'Неизвестно')
        elif i+'.py' in files:
            addons[i] = addon('py', 'Неизвестно', i, i, 'Неизвестно')


    for i in addons:
        if addons[i].type == 'py':
            a = open(es_dir+'%s/%s.%s'%(i, i, addons[i].type), 'r', 256)
            b = a.readlines()
            a.close()
            for j in b:
                if j.startswith('info.'):
                    if j[5:12] == 'version':
                        j = j.replace("'", '"')
                        args = j.split('"')
                        if len(args) > 1:
                            addons[i].version = args[1]
                    elif j[5:9] == 'name':
                        j = j.replace("'", '"')
                        args = j.split('"')
                        if len(args) > 1:
                            addons[i].name = args[1]
                    elif j[5:11] == 'author':
                        j = j.replace("'", '"')
                        args = j.split('"')
                        if len(args) > 1:
                            addons[i].author = args[1]
                elif j.startswith('info['):
                        j = j.replace("'", '"')
                        if j[6:10] == 'name':
                            j = j.split('"')
                            if len(j) > 2:
                                addons[i].name = j[-2]
                        elif j[6:13] == 'version':
                            j = j.split('"')
                            if len(j) > 2:
                                addons[i].version = j[-2]
                        elif j[6:12] == 'author':
                            j = j.split('"')
                            if len(j) > 2:
                                addons[i].author = j[-2]
    genPopup()

def loadedAddons():
    loaded = []
    for addon in es.addons.getAddonList():
        loaded.append(parseName(addon.__name__))
    return loaded

def parseName(name):
    names = name.split('.')
    string = ''
    for i in names[:-1]:
        string += i + '/'
    return string[:-1]

class addon:
    def __init__(self, vtype, version, loadName, name, author):
        self.type = vtype
        self.version = version
        self.loadName = loadName
        self.name = name
        self.author = author
    def isLoaded(self):
        if self.type == 'py':
            if self.loadName in loadedAddons():
                return True
        else:
            if int(es.exists('script', self.loadName)):
                return True
        return False

def genPopup():
    global popup
    if popup: popup.delete()
    popup = popuplib.easymenu('am_menu', None, menuhandle)
    popup.settitle('Скрипты')
    for i in addons:
        popup.addoption(i, addons[i].name)

def menuhandle(userid, choice, popupname):
    global submenu
    submenu = popuplib.easymenu('am_submenu', None, subhandle)
    submenu.settitle(addons[choice].name)
    submenu.addoption(None, '- Автор  : %s'%(addons[choice].author), state=0)
    submenu.addoption(None, '- Версия : %s'%(addons[choice].version), state=0)
    submenu.addoption(None, '- Тип    : %s'%(addons[choice].type), state=0)
    if addons[choice].isLoaded():
        submenu.addoption('unload %s'%choice, 'Выключить скрипт')
    else:
        submenu.addoption('load %s'%choice, 'Включить скрипт')
    submenu.addoption('return', 'Вернуться к скриптам')
    submenu.send(userid)

def subhandle(userid, choice, popupname):
    if choice:
        if choice == 'return':
            popup.send(userid)
        else:
            c = choice.split(' ')
            if c[0] == 'load':
                es.load(c[1])
                gamethread.delayed(0.1, menuhandle, (userid, c[1], 0))
            elif c[0] == 'unload':
                es.unload(c[1])
                gamethread.delayed(0.1, menuhandle, (userid, c[1], 0))

def sendMenu():
    userid = es.getcmduserid()
    steam = es.getplayersteamid(userid)
    if auth(steam):
        popup.send(userid)
    else:
        es.tell(userid, '#multi', '#green[Addon Manager]#lightgreen Вы не админ и не можете использовать эту команду.')

def setup_auth():
    global isAuthed
    if services.isRegistered('auth'):
        auth_service = services.use('auth')
        auth_service.registerCapability('manage_addons', auth_service.ADMIN)
        isAuthed = lambda x: auth_service.isUseridAuthorized(x, 'manage_addons')
    else:
        isAuthed = lambda x: False

def am_load():
    basename = es.getargv(1)
    name = es.getargv(2)
    author = es.getargv(3)
    version = es.getargv(4)
    if addons.has_key(basename):
        if not addons[basename].isLoaded():
            gamethread.delayed(1, set_info, (basename, name, author, version))
        else:
            es.dbgmsg(0, 'Addon is already loaded. Unload it, and try again')
    else:
        es.dbgmsg(0, 'Either the script doesn\'t exist, or it is a sub-script')

def set_info(basename, name, author, version):
    global addons
    if basename and name and author and version:
        es.load(basename)
        if addons[basename].name == basename: addons[basename].name = name
        if addons[basename].author == 'Неизвестно': addons[basename].author = author
        if addons[basename].version == 'Неизвестно': addons[basename].version = version
        genPopup()
    else:
        es.dbgmsg(0, 'Invalid Syntax or Invalid number of args')
        es.dbgmsg(0, 'Syntax: am_load <basename> <addon name> <author> <version>')
    

def auth(steam):
    if steam in admins: return 1
    return isAuthed(es.getuserid(steam))