#!/usr/bin/env python
# -*- coding: utf-8 -*-

# An ES Tools replacement on new CS:S update by fratacos
# Version 0.35

import es
import est
import gamethread
import os.path

deadchat = es.ServerVar("est_dead_chat", 0, "enable/disable dead chat")

reg_list = [
["est_cash", est.cash, 3, 3, 0, "<users> <+,-,=> <value>", ""],
["est_csay", est.csay, 2, 2, 0, "<users> <text>", ""],
["est_curtime", est.curtime, 1, 1, 1, "<variable>", ""],
["est_deafen", est.deafen, 5, 5, 0, "<users> <total time> <percent> <fadeout time> <fadeback time>", ""],
["est_deleteragdolls", est.deleteragdolls, 0, 1, 0, "[users]", ""],
["est_endround", est.endround, 2, 2, 0, "<time> <reason>", ""],
["est_entteleport", est.entteleport, 4, 4, 0, "<index> <x> <y> <z>", ""],
["est_fade", est.fade, 8, 8, 0, "<users> <type> <fadetime> <totaltime> <r> <g> <b> <a>", ""],
["est_freeze", est.freeze, 2, 2, 0, "<users> <1,0>", ""],
["est_getgun", est.getgun, 2, 2, 1, "<variable> <userid>", ""],
["est_getkills", est.getkills, 2, 2, 1, "<variable> <userid>", ""],
["est_god", est.god, 1, 2, 0, "<users> [1,0]", ""],
["est_hsay", est.hsay, 2, 2, 0, "<users> <text>", ""],
["est_kills", est.kills, 3, 3, 0, "<users> <+,-,=> <value>", ""],
["est_loop", est.loop, 3, 3, 0, "<variable> <users> <command>", ""],
["est_name", est.name, 2, 2, 0, "<users> <string>", ""],
["est_remove", est.remove, 1, 1, 0, "<entity>", ""],
["est_removeidle", est.removeidle, 1, 1, 0, "<weapon / weapon_...>", ""],
["est_removeweapon", est.removeweapon, 2, 2, 0, "<users> <weapon,1,2,3,4>", ""],
["est_setentname", est.setentname, 2, 2, 0, "<index> <name>", ""],
["est_setgravity", est.setgravity, 2, 2, 0, "<users> <ratio>", ""],
["est_setmodel", est.setmodel, 2, 2, 0, "<users> <model path>", ""],
["est_setplayercolor", est.setplayercolor, 6, 6, 0, "<users> <r> <g> <b> <a> <1:include weapon/0:player only>", ""],
["est_spawn", est.spawn, 1, 2, 0, "<users> [1,0]", ""],
["est_speed", est.speed, 2, 2, 0, "<users> <speed>", ""],
["est_stripplayer", est.stripplayer, 2, 2, 0, "<users> <1,0>", ""],
["est_team", est.team, 2, 2, 0, "<users> <team>", ""],
["est_teleport", est.teleport, 4, 4, 0, "<users> <x> <y> <z>", ""],
]

def load():
	global handles
	handles = []
	# es.set("est_Hook_Events_Matching", es.ServerVar("est_Hook_Events_Matching"))
	# handles.append(nt.conVarRegister("est_Hook_Events_Matching", est_hookeventsmatching))
	file = (__name__).split(".")[0]
	for item in reg_list:
		if not es.exists("command", item[0]):
			es.regcmd(item[0], "%s/reg_cmd" % file, item[6])
	if os.path.exists("cstrike/cfg/es_tools.cfg"):
		es.ServerCommand("exec es_tools.cfg")

def reg_cmd():
	name = es.getargv(0)
	flag = 0
	for item in reg_list:
		if item[0] == name:
			flag = 1
			break
	if flag == 0:
		return
	argc = es.getargc() - 1
	if not (item[2] <= argc and argc <= item[3]):
		es.dbgmsg(0, "Syntax: " + name + " " + item[5])
		return
	func = item[1]
	arglist = []
	count = 0
	while count < argc:
		count += 1
		if count != item[4]:
			arglist.append(es.getargv(count))
	if item[4] > 0:
		ret = func(*arglist)
		es.ServerCommand("%s %s" % (es.getargv(item[4]), ret))
	else:
		func(*arglist)

def unload():
	global handles
	#nt.unregisterHandles(handles)

def es_player_chat(event_var):
	global deadchat
	if deadchat:
		est.es_player_chat(event_var)

def es_map_start(event_var):
	est.es_map_start(event_var)

def round_start(event_var):
	est.round_start(event_var)

def hook_round_end(event_var):
	es.addons.triggerEvent("round_end")
	return False

def hooking(event_var):
	return False

hook_list = [ ["round_end", hook_round_end] ]

def est_hookeventsmatching(value):
	for item in hook_list:
		if item[0] in value:
			handles.append(nt.preEventRegister("round_end", hooking))