#!/usr/bin/env python
# -*- coding: utf-8 -*-

# An ES Tools replacement on new CS:S update by fratacos
# Version 0.35

#[Added]
#est_spawn
#est_team

#[Fixed]
#csay and hsay unicode problem caused by some ascii characters

#[TODO]
#name and steamid for Est PlayerSelection
#upper and lower case in es.regcmd
#armor, adddownload, health, burn, extinguish, damage, disolve, uptime, slay, getviewprop
#rocket
#jetpack
#shake
#showmenu
#NearCoord
#IsAlive
#RoundDecimal
#GetViewCoord
#playplayer
#randplayer
#SetClipAmmo
#est_give
#physpush
#est_allowadvanceddrop

#[currently not possible]
#restrict*
#est_effect*
#est_enable_PerUserKeyEvents
#est_DeathSet

import es
#import nativetools as nt
import gamethread
import playerlib
import time

spawn_time = 0
spawn_queue = []
timer = 0

def cash(users, param, value):
	v = int(value)
	for userid in getusers(users):
		if param == "=":
			es.setplayerprop(userid, "CCSPlayer.m_iAccount", v)
		else:
			now = es.getplayerprop(userid, "CCSPlayer.m_iAccount")
			if param == "+":
				now += v
			if param == "-":
				now -= v
			es.setplayerprop(userid, "CCSPlayer.m_iAccount", now)
def csay(users, text):
	unicode = 1
	error = ":; "
	for item in error:
		if item in text:
			unicode = 0
	if unicode:
		msg = '"' + text + '"'
	else:
		msg = text
	es.usermsg("create", "centermsg", "TextMsg")
	es.usermsg("write", "byte", "centermsg", 4)
	es.usermsg("write", "string", "centermsg", msg)
	for userid in getusers(users):
		es.usermsg("send", "centermsg", userid)
	es.usermsg("delete", "centermsg")
def curtime():
	# return nt.getServerTiming(nt.TI_TICKCOUNT) * nt.getServerTiming(nt.TI_FRAMETIME)
	global timer
	return (time.time() - timer)
def deafen(users, total, percent, fadeout, fadeback):
	for userid in getusers(users):
		es.fadevolume(userid, percent, fadeout, total, fadeback)
def deleteragdolls(users = 0):
	if str(users) == "0":
		es.ServerCommand("es_delayed 0.15 es_fire %s cs_ragdoll kill" % es.getuserid())
		return
	handles = []
	for userid in getusers(users):
		handles.append(es.getplayerhandle(userid))
	ragdolls = es.createentitylist("cs_ragdoll")
	for index in ragdolls:
		if es.getindexprop(index, "CCSRagdoll.m_hPlayer") in handles:
			setentname(index, "theragdoll")	
	es.ServerCommand("es_delayed 0.15 es_fire %s theragdoll kill" % es.getuserid())
def endround(time, reason):
	t = int(time)
	r = int(reason)
	if not (0 < r and r < 17):
		return
	data = [["#Target_Bombed", 2], ["#VIP_Escaped", 3], ["#VIP_Assassinated", 2], ["#Terrorists_Escaped", 2], ["#CTs_PreventEscape", 3], ["#Escaping_Terrorists_Neutralized", 3], ["#Bomb_Defused", 3], ["#CTs_Win", 3], ["#Terrorists_Win", 2], ["#Round_Draw", 0], ["#All_Hostages_Rescued", 3], ["#Target_Saved", 3], ["#Hostages_Not_Rescued", 2], ["#Terrorists_Not_Escaped", 3], ["#VIP_Not_Escaped", 2], ["#Game_Commencing", 0]]
	winner = data[r - 1][1]
	text = data[r - 1][0]
	es.event("initialize", "round_end")
	es.event("setint", "round_end", "winner", winner)
	es.event("setint", "round_end", "reason", r)
	es.event("setstring", "round_end", "message", text)
	es.event("fire", "round_end")
	gamethread.delayed(t, endround_delayed1, (t, text))
	gamethread.delayed(t + 0.20, endround_delayed2, (t, text))
def endround_delayed1(t, text):
	es.flags("remove", "cheat", "endround")
	es.ServerCommand("endround")
def endround_delayed2(t, text):
	es.flags("add", "cheat", "endround")
	if t >= 2:
		es.centermsg("")
	else:
		es.centermsg(text)
def entteleport(index, x, y, z):
	setentname(index, "theentity")
	es.ServerCommand('es_fire %s theentity addoutput "origin %d %d %d"' % (es.getuserid(), float(x), float(y), float(z)))
def hsay(users, text):
	unicode = 1
	error = ":; "
	for item in error:
		if item in text:
			unicode = 0
	if unicode:
		msg = '"' + text + '"'
	else:
		msg = text
	es.usermsg("create", "hudhint", "HintText")
	es.usermsg("write", "string", "hudhint", msg)
	for userid in getusers(users):
		es.usermsg("send", "hudhint", userid)
	es.usermsg("delete", "hudhint")
def kills(users, param, v):
	value = int(v)
	trigger = es.getuserid()
	es.ServerCommand("es_give %s game_score" % trigger)
	es.ServerCommand('es_fire %s game_score addoutput "spawnflags 1"' % trigger)
	if param == "+":
		apply = value
	if param == "-":
		apply = -value
	for userid in getusers(users):
		if param == "=":
			apply = value - getkills(userid)
		es.ServerCommand('es_fire %s game_score addoutput "points %d"' % (userid, apply))
		es.ServerCommand("es_fire %s game_score ApplyScore" % userid)
	es.ServerCommand("es_fire %s game_score kill" % trigger)
def getkills(userid):
	# need fix with scores; hard coded to CS:S
	index = es.getentityindex("cs_player_manager")
	return es.getindexprop(index, "CPlayerResource.m_iScore.%.3d" % playerlib.getPlayer(userid).attributes["index"])
def fade(users, type, fadetime, totaltime, r, g, b, a):
	t = int(type)
	if t == 1:
		type = 2
	elif t == 0:
		type = 1
	else:
		type = 8 + 16
	es.usermsg("create", "fade", "Fade")
	es.usermsg("write", "short", "fade", int(fadetime) * 1000)
	es.usermsg("write", "short", "fade", int(totaltime) * 1000)
	es.usermsg("write", "short", "fade", int(type))
	es.usermsg("write", "byte", "fade", int(r))
	es.usermsg("write", "byte", "fade", int(g))
	es.usermsg("write", "byte", "fade", int(b))
	es.usermsg("write", "byte", "fade", int(a))
	for userid in getusers(users):
		es.usermsg("send", "fade", userid)
	es.usermsg("delete", "fade")
def freeze(users, param = 1):
	for userid in getusers(users):
		movetype = es.getplayerprop(userid, "CBaseEntity.movetype")
		if str(param) == "1":
			if movetype & 2:
				es.setplayerprop(userid, "CBaseEntity.movetype", movetype - 2)
		else:
			if not movetype & 2:
				es.setplayerprop(userid, "CBaseEntity.movetype", movetype + 2)
def getgun(userid):
	# return nt.weaponCurrent(userid)
	return playerlib.getPlayer(userid).weapon
def god(users, param = 1):
	for userid in getusers(users):
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if not dead:
			if str(param) == "1":
				es.setplayerprop(userid, "CBasePlayer.m_lifeState", 0)
			else:
				es.setplayerprop(userid, "CBasePlayer.m_lifeState", 512)
def loop(variable, users, command):
	es.msg([variable, users, command])
	for userid in getusers(users):
		es.ServerCommand("%s %s" % (variable, userid))
		es.ServerCommand(command)
def name(users, value):
	for userid in getusers(users):
		if es.getplayersteamid(userid) == "BOT":
			es.botsetvalue(userid, "name", value)
		else:
			es.cexec(userid, "name %s" % value)
def remove(param):
	es.ServerCommand("es_fire %s %s kill" % (es.getuserid(), param))
def removeidle(param):
	if param == "weapon":
		weapons = ["weapon_ak47", "weapon_aug", "weapon_awp", "weapon_c4", "weapon_deagle", "weapon_elite", "weapon_famas", "weapon_fiveseven", "weapon_flashbang", "weapon_g3sg1", "weapon_galil", "weapon_glock", "weapon_hegrenade", "weapon_knife", "weapon_m249", "weapon_m3", "weapon_m4a1", "weapon_mac10", "weapon_mp5navy", "weapon_p228", "weapon_p90", "weapon_scout", "weapon_sg550", "weapon_sg552", "weapon_smokegrenade", "weapon_tmp", "weapon_ump45", "weapon_usp", "weapon_xm1014"]
		for weapon in weapons:
			removeidle(weapon)
		return
	weapon = es.createentitylist(param)
	for index in weapon:
		if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") == -1:
			setentname(index, "theweapon")
	es.ServerCommand("es_fire %s theweapon kill" % es.getuserid())
def removeweapon(users, param):
	if str(param) in ["1", "2", "3", "4"]:
		for userid in getusers(users):
			handle = es.getplayerhandle(userid)
			# name = nt.weaponSlot(userid, int(param) - 1)
			player = playerlib.getPlayer(userid)
			no = int(param)
			if no == 1:
				name = ["weapon_ak47", "weapon_sig552", "weapon_mac10", "weapon_sg550", "weapon_scout", "weapon_awp", "weapon_famas", "weapon_m4a1", "weapon_mp5navy", "weapon_ump45", "weapon_g3sg1", "weapon_xm1014", "weapon_p90", "weapon_aug"]
			if no == 2:
				name = ["weapon_glock", "weapon_usp", "weapon_deagle", "weapon_elite", "weapon_p228", "weapon_fiveseven"]
			if no == 3:
				name = ["weapon_knife"]
			if no == 4:
				name = ["weapon_hegrenade", "weapon_smokegrenade", "weapon_flashbang"]
			weapon = []
			for item in name:
				weapon.extend(es.createentitylist(item))
			for index in weapon:
				if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") == handle:
					setentname(index, "theweapon")
					if no in [1, 2]:
						break
	else:
		handles = []
		for userid in getusers(users):
			handles.append(es.getplayerhandle(userid))
		weapon = es.createentitylist(param)
		for index in weapon:
			if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") in handles:
				setentname(index, "theweapon")
	es.ServerCommand("es_fire %s theweapon kill" % es.getuserid())
def setentname(index, param):
	# nt.entitySetName(index, param)
	es.setentityname(index, param)
def setgravity(users, ratio):
	for userid in getusers(users):
		es.ServerCommand('es_xfire %s !self addoutput "gravity %f"' % (userid, float(ratio)))
def setmodel(users, model):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.setModel(model)
def setplayercolor(users, r, g, b, a, weapon):
	w = int(weapon)
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.setColor(int(r), int(g), int(b), int(a))
		if w == 1:
			player.setWeaponColor(int(r), int(g), int(b), int(a))
def spawn(users, param = 0):
	users = getusers(users)
	for userid in users:
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if int(param) == 0 and not dead:
			continue
		es.setplayerprop(userid, "CCSPlayer.m_iPlayerState", 0)
		gamethread.delayed(0.05, es.spawnplayer, userid)
def speed(users, value):
	for userid in getusers(users):
		es.setplayerprop(userid, "CBasePlayer.localdata.m_flLaggedMovementValue", value)
def stripplayer(users, param = 0):
	trigger = es.getuserid()
	es.ServerCommand("es_give %s player_weaponstrip" % trigger)
	for userid in getusers(users):
		if str(param) != "0":
			es.ServerCommand("es_fire %s player_weaponstrip StripWeaponsAndSuit" % userid)
		else:
			es.ServerCommand("es_fire %s player_weaponstrip Strip" % userid)
	es.ServerCommand("es_fire %s Strip kill" % trigger)
def team(users, no):
	for userid in getusers(users):
		es.setplayerprop(userid, "CBaseEntity.m_iTeamNum", int(no))
		es.changeteam(userid, int(no))
def teleport(users, x, y, z):
	for userid in getusers(users):
		es.setpos(userid, float(x), float(y), float(z))

def es_player_chat(event_var):
	userid = event_var["userid"]
	if int(userid) <= 0:
		return
	team = es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")
	flag = 0
	if team == 1:
		if not int(event_var["teamonly"]):
			players = playerlib.getPlayerList("#alive")
			type = "#Cstrike_Chat_AllSpec"
			flag = 1
	elif es.getplayerprop(userid, "CBasePlayer.pl.deadflag") == 1:
		flag = 1
		if int(event_var["teamonly"]):
			if team == 2:
				str = "#t,#alive"
				type = "#Cstrike_Chat_T_Dead"
			if team == 3:
				str = "#ct,#alive"
				type = "#Cstrike_Chat_CT_Dead"
			players = playerlib.getPlayerList(str)
		else:
			players = playerlib.getPlayerList("#alive")
			type = "#Cstrike_Chat_AllDead"
	if flag:
		name = '"%s"' % es.getplayername(userid)
		text = '"%s"' % event_var["text"]
		es.usermsg('create', 'saytext', 'SayText2')
		es.usermsg('write', 'byte', 'saytext', event_var["es_userindex"])
		es.usermsg('write', 'byte', 'saytext', 1)
		es.usermsg('write', 'string', 'saytext', type)
		es.usermsg('write', 'string', 'saytext', name)
		es.usermsg('write', 'string', 'saytext', text)
		for player in players:
			es.usermsg('send', 'saytext', player.userid)
		es.usermsg('delete', 'saytext')

def es_map_start(event_var):
	global spawn_time
	global spawn_queue
	spawn_time = 0
	spawn_queue = []

def round_start(event_var):
	global timer
	timer = time.time()

def getusers(users):
	#TODO: http://www.eventscripts.com/pages/Est_PlayerSelection
	# Python style #alive, #all, #bot, #ct, #dead, #human, #spec, #t, #un
	# ex: #alive,#ct (for CT who is alive)
	# EST style #a, #c, #3, #t, #2, #s, #1, #u, #0, #h, #b, #l, #d
	# ex: #23!d (for all T and CT who is alive)
	# unclear case: #ct (use #tc or #23 instead for EST style)
	pyfilter = ["#alive", "#all", "#bot", "#ct", "#dead", "#human", "#spec", "#t", "#un"]
	if str(users)[0] == "#":
		status = 0
		notfilter = ""
		if "," in users:
			status = 1
		if "!" in users:
			all = users.split("!")
			users = all[0]
			notfilter = all[1]
			status = 2
		if status == 0:
			if users in pyfilter:
				status = 1
			else:
				status = 2
		if status == 2:
			est = [["t","#t"], ["c","#ct"], ["3","#ct"], ["2","#t"], ["s","#spec"], ["1","#spec"], ["u","#un"], ["h","#human"], ["b","#bot"], ["l","#alive"], ["a","#all"], ["d","#dead"] ]
			filter = []
			for item in est:
				if item[0] in users:
					idlist = playerlib.getUseridList(item[1])
					filter.extend(idlist)
			users = set(filter)
			if notfilter != "":
				filter = []
				for item in est:
					if item[0] in notfilter:
						idlist = playerlib.getUseridList(item[1])
						filter.extend(idlist)
				notfilter = set(filter)
				for item in notfilter:
					users.remove(item)
		else:
			users = playerlib.getUseridList(users)
	elif not hasattr(users, "__iter__"):
		users = (users,)
	return users