# -*- coding:Utf-8 -*-

# ==================================================
#  >> IMPORTATIONS
# ==================================================


import es
import usermsg
import langlib
import gamethread
import playerlib

import os
import re
import configobj
import random

import psyco
psyco.full()


# ==================================================
#  >> INFORMATIONS
# ==================================================


informations = es.AddonInfo()
informations["name"] = "GoreMod by L'In20Cible"
informations["version"] = "2.2"
informations["date"] = "2010-04-16"
informations["author"] = "L\'in20Cible"
informations["credits"] = "Mattie, Awuh0 , Robot , Drkgeek, Fresh lemon & Grizzly."
informations["url"] = "http://addons.eventscripts.com/addons/view/goremod/"
informations["basename"] = "goremod"

es.ServerVar(("gm_credits"), informations["credits"]).makepublic()
es.ServerVar(("gm_version"), (informations["version"] + " by " + informations["author"])).makepublic()


# ==================================================
#  >> GLOBALES
# ==================================================


players = list()

es_gamedir = es.getString("eventscripts_gamedir").replace(os.sep, "/")
es_currentmap = es.ServerVar("eventscripts_currentmap")
es_addondir = es.getString("eventscripts_addondir").replace(os.sep, "/")

options = dict()
options["enable"] = es.ServerVar("gm_enable", "1", "gm_enable <1/0> -- Active/désactive le GoreMod.")
options["downloads_enable"] = es.ServerVar("gm_downloads_enable", "1", "gm_downloads_enable <1/0> -- Active/désactive les téléchargement du GoreMod.")

options["blood_enable"] = es.ServerVar("gm_blood_enable", "1", "gm_blood_enable <1/0> -- Active/désactive le surplus de sang.")
options["blood_amount"] = es.ServerVar("gm_blood_amount", "12", "gm_blood_amount <nombre entier> -- Définit la quantité de surplus de sang.")
options["blood_alien"] = es.ServerVar("gm_blood_alien", "0", "gm_blood_alien <1/0> -- Active/désactive le surplus de sang alien.")
options["blood_players"] = es.ServerVar("gm_blood_players", "1", "gm_blood_players <1/0> -- Active/désactive le surplus de sang sur les joueurs.")
options["blood_hostages"] = es.ServerVar("gm_blood_hostages", "1", "gm_blood_hostages <1/0> -- Active/désactive le surplus de sang sur les otages.")

options["decapitation_enable"] = es.ServerVar("gm_decapitation_enable", "1", "gm_decapitation_enable <1/0> -- Active/désactive la décapitation.")
options["decapitation_bleeding"] = es.ServerVar("gm_decapitation_bleeding", "1", "gm_decapitation_bleeding <1/0> -- Active/désactive les saignements causés par une décapitation.")
options["decapitation_weapons"] = es.ServerVar("gm_decapitation_weapons", "world,worldspawn,point_hurt,hegrenade,flashbang,knife", "gm_decapitation_weapons <liste> -- Définit les armes qui décapiteront leurs victimes.")
options["decapitation_damages"] = es.ServerVar("gm_decapitation_damages", "1", "gm_decapitation_damages <1/0> -- Active/désactive les dommages causés par une décapitation.")
options["decapitation_sounds"] = es.ServerVar("gm_decapitation_sounds", "goremod/decapitation.wav", "gm_decpitation_sounds <liste> -- Définit les sons joués de façon aléatoire lors d'une décapitation.")
options["decapitation_shake"] = es.ServerVar("gm_decapitation_shake", "1", "gm_decapitation_shake <1/0> -- Active/désactive les secousses causés par une décapitation.")

options["explosion_enable"] = es.ServerVar("gm_explosion_enable", "1", "gm_explosion_enable <1/0> -- Active/désactive les explosions.")
options["explosion_weapons"] = es.ServerVar("gm_explosion_weapons", "knife,awp,deagle,flashbang", "gm_explosion_weapons <liste> -- Définit les armes qui exploseront automatiquement leurs victimes.")
options["explosion_headshot"] = es.ServerVar("gm_explosion_headshot", "1", "gm_explosion_headshot <1/0> -- Active/désactive l'explosion des joueurs victime d'un headshot.")
options["explosion_teamkill"] = es.ServerVar("gm_explosion_teamkill", "0", "gm_explosion_teamkill <1/0> -- Active/désactive l'explosion des joueurs victime d'un teamkill.")
options["explosion_sounds"] = es.ServerVar("gm_explosion_sounds", "goremod/explosion.wav", "gm_explosion_sounds <liste> --  Définit les sons joués de façon aléatoire lors d'une explosion.")

options["carbonization_enable"] = es.ServerVar("gm_carbonization_enable", "1", "gm_carbonization_enable <1/0> -- Active/désactive les carbonizations.")
options["carbonization_weapons"] = es.ServerVar("gm_carbonization_weapons", "world,worldspawn,point_hurt,hegrenade", "gm_carbonization_weapons <liste> -- Définit les armes qui carboniseront automatiquement leur victimes.")
options["carbonization_sounds"] = es.ServerVar("gm_carbonization_sounds", "goremod/carbonization.wav", "gm_carbonization_sounds <liste> --  Définit les sons joués de façon aléatoire lors d'une carbonisation.")
options["carbonization_overlay"] = es.ServerVar("gm_carbonization_overlay", "goremod/overlays/carbonization", "gm_carbonization_overlay <chaine de caractère> --  Définit l'overlay à utiliser lors d'une carbonisation.")


# ==================================================
#  >> INITIALISATION
# ==================================================


def load():
   global players
   Initialization()
   if not len(players):
      return
   players = list()
   
   
def Initialization():
   global models, translations
   models = dict()
   try:
      models = ConfigurationFileParser(GetConfigurationFilePath("models.ini"))
   except:
      pass
   filepath = GetConfigurationFilePath("configuration.cfg")
   if os.path.isfile(filepath):
      es.mexec(filepath.replace(es_gamedir, ".."))
   try:
      translations = langlib.Strings(GetConfigurationFilePath("translations.ini"))
   except:
      translations = TranslationsFileAreMissingCallBack
   filepath = GetConfigurationFilePath("downloads.txt")
   if int(options["downloads_enable"]) and (str(es_currentmap) <> "") and os.path.isfile(filepath):
      regex = re.compile("//.*|^(( |\t)+)|(( |\t)+)$|(\r)+|(\n)+")
      for fileline in open(filepath):
         fileline = regex.sub("", fileline).strip()
         if not fileline:
            continue
         es.stringtable("downloadables", fileline)
         
         
# ==================================================
#  >> CLASSES
# ==================================================


class ConfigurationFileParser(configobj.ConfigObj):
   def __getitem__(self, itemname):
      if itemname not in self:
         return ""
      return super(ConfigurationFileParser, self).__getitem__(itemname)
      
      
# ==================================================
#  >> UTILITAIRES
# ==================================================


def GetConfigurationFilePath(filename):
   return os.path.join(es_addondir, informations["basename"], "configuration", filename).replace(os.sep, "/")
   
   
def GetPlayerHitGroupLocation(userid, hitgroup):
   userid = int(userid)
   hitgroup = int(hitgroup)
   if not es.exists("userid", userid) or (hitgroup not in xrange(-1,  8)):
      return
   x, y, z = es.getplayerlocation(userid)
   if hitgroup == 1:
      z = (z + 65)
   elif hitgroup in (2, 3, 4, 5):
      z = (z + 45)
   elif hitgroup in (6, 7):
      z = (z + 25)
   if (es.getplayerprop(userid, "CBasePlayer.localdata.m_Local.m_bDucked") % 2):
      z = (z - 20)
   return tuple([x, y, z])
   
   
def CreateBloodEffect(userid, origin):
   userid = int(userid)
   if not es.exists("userid", userid):
      return
   es.server.queuecmd("es_xentcreate %i env_blood" % userid)
   es.server.queuecmd("es_xfire %i env_blood addoutput \"amount %i\"" % (userid, int(options["blood_amount"])))
   es.server.queuecmd("es_xfire %i env_blood addoutput \"color %i\"" % (userid, int(options["blood_alien"])))
   es.server.queuecmd("es_xfire %i env_blood addoutput \"spawnflags 1321\"" % userid)
   es.server.queuecmd("es_xfire %i env_blood addoutput \"origin %s %s %s\"" % (userid, origin[0], origin[1], origin[2]))
   es.server.queuecmd("es_xfire %i env_blood emitblood" % userid)
   es.server.queuecmd("es_xfire %i env_blood kill" % userid)
   
   
def CreateShootEffect(userid, origin, model, amount):
   userid = int(userid)
   if not es.exists("userid", userid):
      return
   while (amount > 0):
      amount = (amount - 1)
      es.server.queuecmd("est_effect 12 #h 0 %s %s %s %s %s %s %s 0 0 500 0 0 0" % (model, origin[0], origin[1], origin[2], random.randint(-1000, 1000), random.randint(-1000, 1000), random.randint(-1000, 1000)))
      
      
def GetPlayerLanguage(userid):
   return langlib.getLangAbbreviation(es.getclientvar(userid, "cl_language"))
   
   
def PlayerBleed(userid):
   userid = int(userid)
   if not int(options["enable"]) or not int(options["decapitation_bleeding"]) or not es.exists("userid", userid) or (userid not in players):
      return
   if not es.getplayerprop(userid, "CBasePlayer.pl.deadflag"):
      if int(options["decapitation_shake"]) and not es.isbot(userid):
         usermsg.shake(userid, 10, 0.5)
      CreateBloodEffect(userid, GetPlayerHitGroupLocation(userid, 1))
      if random.randint(1, 3) == 2:
         userhealth = (es.getplayerprop(userid, "CBasePlayer.m_iHealth") - 1)
         es.emitsound("player", userid, ("player/damage%i.wav" % random.randint(1, 3)), 0.9, 10)
         if userhealth > 0:
            es.setplayerprop(userid, "CBasePlayer.m_iHealth", userhealth)
         else:
            es.sexec(userid, "kill")
      gamethread.delayed(random.random(), PlayerBleed, userid)
   else:
      players.remove(userid)
      
      
# ==================================================
#  >> FONCTIONS D'APPEL
# ==================================================


def TranslationsFileAreMissingCallBack(string, tokens, language):
   return "Sorry, the #lightgreentranslations.ini #defaultfile are missing or corrupted."
   
   
# ==================================================
#  >> ÉVÉNEMENTS
# ==================================================


def es_map_start(event_var):
   global players
   Initialization()
   if not len(players):
      return
   players = list()
   
   
def hostage_hurt(event_var):
   if not int(options["enable"]) or not int(options["blood_enable"]) or not int(options["blood_hostages"]):
      return
   x, y, z = es.getindexprop(event_var["hostage"], "CBaseEntity.m_vecOrigin").split(",")
   CreateBloodEffect(event_var["userid"], [x, y, (float(z) + 50)])
   
   
def player_hurt(event_var):
   if not int(options["enable"]):
      return
   userid = int(event_var["userid"])
   if int(options["blood_enable"]) and int(options["blood_players"]):
      CreateBloodEffect(userid, GetPlayerHitGroupLocation(userid, event_var["hitgroup"]))
   if not int(options["decapitation_enable"]) or (userid in players):
      return
   if not es.getplayerprop(userid, "CBasePlayer.pl.deadflag") and ((int(event_var["hitgroup"]) == 1) or (event_var["weapon"] in str(options["decapitation_weapons"]).split(","))):
      playerinfo = es.createplayerlist(userid)[userid]
      usermodel = playerinfo["model"]
      if models[usermodel] and (("head" in models[usermodel]) and ("body" in models[usermodel])):
         if int(options["decapitation_shake"]):
            usermsg.shake(userid, 50, 1.5)
         playerlib.getPlayer(userid).setModel(models[usermodel]["body"])
         CreateShootEffect(userid, GetPlayerHitGroupLocation(userid, 1), models[usermodel]["head"], 1)
         tokens = {"victim": playerinfo["name"],
            "attacker": es.getplayername(event_var["attacker"])}
         for playerid in es.getUseridList():
            if es.isbot(playerid):
               continue
            usermsg.saytext2(playerid, playerinfo["index"], ("[GoreMod] " + translations("decapitation", tokens, GetPlayerLanguage(playerid))))
         players.append(userid)
         if int(options["decapitation_bleeding"]):
            gamethread.delayed(random.random(), PlayerBleed, userid)
         es.emitsound("player", userid, random.choice(str(options["decapitation_sounds"]).split(",")), 0.9, 1.0)
         
         
def player_spawn(event_var):
   userid = int(event_var["userid"])
   if userid in players:
      players.remove(userid)
   es.cexec(userid, 'r_screenoverlay ""')
   
   
def player_death(event_var):
   if not int(options["enable"]):
      return
   exploded = False
   userid = int(event_var["userid"])
   if (event_var["weapon"] in str(options["explosion_weapons"]).split(",")) or (int(options["explosion_headshot"]) and int(event_var["headshot"])) or (int(options["explosion_teamkill"]) and(event_var["es_userteam"] == event_var["es_attackerteam"])):
      userhandle = es.getplayerhandle(userid)
      for ragdollindex in es.createentitylist("cs_ragdoll"):
         if not es.getindexprop(ragdollindex, "CCSRagdoll.m_hPlayer") == userhandle:
            continue
         es.server.queuecmd("es_xremove %i" % ragdollindex)
      CreateBloodEffect(userid, GetPlayerHitGroupLocation(userid, 1))
      hitgrouplocation = GetPlayerHitGroupLocation(userid, 1)
      CreateShootEffect(userid, hitgrouplocation, "models/gibs/hgibs.mdl", 1)
      CreateShootEffect(userid, hitgrouplocation, "models/gibs/hgibs_scapula.mdl", 2)
      CreateShootEffect(userid, hitgrouplocation, "models/gibs/hgibs_spine.mdl", 1)
      CreateShootEffect(userid, hitgrouplocation, "models/gibs/hgibs_rib.mdl", 12)
      playerinfo = es.createplayerlist(userid)[userid]
      tokens = {"victim": playerinfo["name"],
         "attacker": es.getplayername(event_var["attacker"])}
      for playerid in es.getUseridList():
         if es.isbot(playerid):
            continue
         usermsg.saytext2(playerid, playerinfo["index"], ("[GoreMod] " + translations("explosion", tokens, GetPlayerLanguage(playerid))))
      es.emitsound("player", userid, random.choice(str(options["explosion_sounds"]).split(",")), 1.0, 0.5)
      exploded = True
   if int(options["carbonization_enable"]) and (event_var["weapon"] in str(options["carbonization_weapons"]).split(",")) and not exploded:
      userhandle = es.getplayerhandle(userid)
      for ragdollindex in es.createentitylist("cs_ragdoll"):
         if not (es.getindexprop(ragdollindex, "CCSRagdoll.m_hPlayer") == userhandle):
            continue
         ragdollname = ("gm_ragdoll_" + str(ragdollindex))
         es.server.queuecmd("est_setentname %i %s" % (ragdollindex, ragdollname))
         es.server.queuecmd("es_xfire %i %s ignite" % (userid, ragdollname))
         es.cexec(userid, "r_screenoverlay \"%s\"" % str(options["carbonization_overlay"]))
         gamethread.delayed(5.8, es.cexec, (userid, "r_screenoverlay \"\""))
         playerinfo = es.createplayerlist(userid)[userid]
         tokens = {"victim": playerinfo["name"],
            "attacker": es.getplayername(event_var["attacker"])}
         for playerid in es.getUseridList():
            if es.isbot(playerid):
               continue
            usermsg.saytext2(playerid, playerinfo["index"], ("[GoreMod] " + translations("carbonization", tokens, GetPlayerLanguage(playerid))))
         es.emitsound("entity", ragdollindex, random.choice(str(options["carbonization_sounds"]).split(",")), 1.0, 0.9)