﻿import es, popuplib, gamethread

info = es.AddonInfo()
info.name = 'Build'
info.version = '1.0'
info.url = 'http://addons.eventscripts.com/addons/view/Build'
info.basename = 'build'
info.author = 'Deathyy'

es.ServerVar('build_ver', info['version'], 'A build script.').makepublic()

def player_say(ev):
    if ev['text'] == '!props':
        bh.send(ev['userid'])
        
def player_spawn(ev):
    es.server.cmd('est_god %s 1'%(ev['userid']))

def load():
    global bh, bp, br, bm, bc
    
    sendMsg()
    
    bh = popuplib.create('bh')
    a = bh.addline
    a('Меню создания предметов')
    a('->1. Создать предмет')
    a('->2. Вращать предмет')
    a('->3. Переместить предмет')
    a('->4. Удалить предмет')
    a('->5. Разработчики')
    a('0 Выход')
    bh.menuselect = menuHandler
    
    bp = popuplib.create('bp')
    a = bp.addline
    a('Создать предмет:')
    a('->1. Большая дверь от контейнера')
    a('->2. Маленькая дверь от контейнера')
    a('->3. Диван')
    a('->4. Забор')
    a('->5. Пляжный стол')
    a('->6. Кровать')
    a('->7. Большой телевизор')
    a('->8. Назад')
    a('0 Выход')
    bp.menuselect = propsHandler
    
    br = popuplib.create('br')
    a = br.addline
    a('Вращать предмет: ')
    a('->1. +X')
    a('->2. +Y')
    a('->3. +Z')
    a('->4. -X')
    a('->5. -Y')
    a('->6. -Z')
    a('->8. Назад')
    a('0 Выход')
    br.menuselect = rotateHandler
    
    bm = popuplib.create('bm')
    a = bm.addline
    a('Переместить предмет: ')
    a('->1. Вверх')
    a('->2. Влево')
    a('->3. Вперед')
    a('->4. Вниз')
    a('->5. Вправо')
    a('->6. Назад')
    a('->8. Назад в меню')
    a('0 Выход')
    bm.menuselect = moveHandler
    
    bc = popuplib.create('bc')
    a = bc.addline
    a('Разработчики')
    a('Автор : Deathyy')
    a('Автор переевода: Se7en')
    a('Помошник : Mitch')
    a('Версия : 1.0')
    a('Язык : Русский')
    a('Язык програмирования : Python')
    a('Дата выхода : 28.04.2010')
    a('Операционная система : Windows')
    a('->8. Назад')
    a('0 Выход')
    bc.menuselect = creditsHandler
    
def es_map_start(ev):
    sendMsg()
    
def sendMsg():
    gamethread.cancelDelayed('chat_msg')
    es.msg('#multi', '#green[Build] #defaultНапишите #lightgreen!props #defaultчто бы открыть меню создания предметов.')
    gamethread.delayedname(60,'chat_msg',sendMsg)
    
def menuHandler(userid, choice, popupid):
    name = es.getplayername(userid)
    entity_index = es.ServerVar('entity_index', 0, 'The Temporary Entity')
    if choice == 1:
        bp.send(userid)
    elif choice == 2:
        br.send(userid)
    elif choice == 3:
        bm.send(userid)
    elif choice == 4:
        bh.send(userid)
        es.server.cmd('est_getviewprop %s entity_index' % userid)
        if int(entity_index) != 0:
            if es.createentitylist(int(entity_index))[int(entity_index)]['classname'].startswith('prop_'):
                formatname2 = es.ServerVar('formatname2', 'None', 'The name of a temporary entity')
                es.server.cmd('est_getentname formatname2 %s'%(entity_index))
                user = '--%s'%userid
                if str(user) in str(formatname2):
                    es.server.cmd('es_xremove %s' % entity_index)
                    es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultудалил#lightgreen %s'%(name, formatname2))
                if str(user) not in str(formatname2):
                    es.tell(userid,'#multi', '#green[Build] #defaultЭто не ваш предмет!.')
    elif choice == 5:
        bc.send(userid)
        
def propsHandler(userid, choice, popupid):
    steam = es.getplayersteamid(userid)
    name = es.getplayername(userid)
    if choice == 1:
        es.server.cmd('es_xprop_dynamic_create %s props_lab/blastdoor001c'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 2:
        es.server.cmd('es_xprop_dynamic_create %s props_lab/blastdoor001b'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 3:
        es.server.cmd('es_xprop_dynamic_create %s props\CS_militia\couch'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 4:
        es.server.cmd('es_xprop_dynamic_create %s props_c17/fence03a'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 5:
        es.server.cmd('es_xprop_dynamic_create %s props\de_tides\patio_table'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 6:
        es.server.cmd('es_xprop_dynamic_create %s props/de_inferno/bed'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 7:
        es.server.cmd('es_xprop_dynamic_create %s props/CS_militia/television_console01'%(userid))
        bp.send(userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        formatname = 'wall_%s--%s'%(lastgive, userid)
        es.server.cmd('es est_setentname %s %s' % (lastgive, formatname))
        es.tell(userid, '#multi', '#green[Build] #lightgreen%s #defaultсоздал #lightgreen wall_%s--%s'%(name, lastgive, userid))
    elif choice == 8:
        bh.send(userid)
        
def rotateHandler(userid, choice, popupid):
    if choice == 1:
        rotateway(userid, choice)
    if choice == 2:
        rotateway(userid, choice)
    if choice == 3:
        rotateway(userid, choice)
    if choice == 4:
        rotateway(userid, choice)
    if choice == 5:
        rotateway(userid, choice)
    if choice == 6:
        rotateway(userid, choice)
    if choice == 8:
        bh.send(userid)
        
def rotateway(userid, choice):
    br.send(userid)
    name = es.getplayername(userid)
    entity_index = es.ServerVar('entity_index', 0, 'The Temporary Entity')
    es.server.cmd('est_getviewprop %s entity_index'%(userid))
    if int(entity_index) != 0:
        if es.createentitylist(int(entity_index))[int(entity_index)]['classname'].startswith('prop_'):
            formatname2 = es.ServerVar('formatname2', "None", 'The name of a temporary entity')
            es.server.cmd('est_getentname formatname2 %s'%(entity_index))
            user = '--%s'%userid
            if str(user) in str(formatname2):
                rotation = es.getindexprop(entity_index, 'CDynamicProp.baseclass.baseclass.baseclass.m_angRotation')
                x, y, z = es.splitvectorstring(rotation)
                if choice == 1:
                    x = x + 45
                    if x == 05:
                        x = 45
                if choice == 2:
                    y = y + 45
                    if y == 405:
                        y = 45
                if choice == 3:
                    z = z + 45
                    if z == 405:
                        z = 45
                if choice == 4:
                    x = x - 45
                    if x == -45:
                        x = 315
                if choice == 5:
                    y = y - 45
                    if y == -45:
                        y = 315
                if choice == 6:
                    z = z - 45
                    if z == -45:
                        z = 315
                vector = 'angles %s %s %s'%(x, y, z)
                walls = 'wall_%s--%s'%(entity_index, userid)
                es.server.cmd('es_xfire %s %s addoutput "%s"' % (userid, walls, vector))
            if str(user) not in str(formatname2):
                es.tell(userid,'#multi', '#green[Build] #defaultЭто не ваш предмет.')
                    
def moveHandler(userid, choice, popupid):
    if choice == 1:
        moveway(userid, choice)
    if choice == 2:
        moveway(userid, choice)
    if choice == 3:
        moveway(userid, choice)
    if choice == 4:
        moveway(userid, choice)
    if choice == 5:
        moveway(userid, choice)
    if choice == 6:
        moveway(userid, choice)
    if choice == 8:
        bh.send(userid)
       
def moveway(userid, choice):
    bm.send(userid)
    name = es.getplayername(userid)
    entity_index = es.ServerVar('entity_index', 0, 'The index of a temporary entity')
    es.server.cmd('est_getviewprop %s entity_index' % userid)
    if int(entity_index) != 0:
        if es.createentitylist(int(entity_index))[int(entity_index)]['classname'].startswith('prop_'):
            formatname2 = es.ServerVar('formatname2', "None", 'The name of a temporary entity')
            es.server.cmd('est_getentname formatname2 %s'%(entity_index))
            user = "--%s"%userid
            if str(user) in str(formatname2):
                org = es.getindexprop(entity_index, 'CDynamicProp.baseclass.baseclass.baseclass.m_vecOrigin')
                x, y, z = es.splitvectorstring(org)
                if choice == 1:
                    z = z + 8
                if choice == 2:
                    y = y + 8
                if choice == 3:
                    x = x + 8
                if choice == 4:
                    z = z - 8
                if choice == 5:
                    y = y - 8
                if choice == 6:
                    x = x - 8
                vector = 'origin %s %s %s'%(x, y, z)
                walls = 'wall_%s--%s'%(entity_index, userid)
                es.server.cmd('es_xfire %s %s addoutput "%s"' % (userid, walls, vector))
            if str(user) not in str(formatname2):
                es.tell(userid,'#multi', '#green[Build] #defaultЭто не ваш предмет.')
                
def creditsHandler(userid, choice, popupid):
    if choice == 8:
        bh.send(userid)

def unload():
    gamethread.cancelDelayed('chat_msg')