# -----------------
# EventScripts Addon:    FlashFun
# Author:                BackRaw (with help from Satoon)
# -----------------

# -----------------
# EventScripts Imports
# -----------------
import es
import gamethread
import random
from playerlib import getPlayer
# -----------------

# -----------------
# Module Imports
# -----------------
from configobj import ConfigObj
if es.exists('variable', 'nativetools_ver'):
    from nativetools import spawnPlayer
# -----------------

''' Global Variables '''

# configuration file "flashfun_config.ini" in folder ./addons/eventscripts/flashfun
config = ConfigObj(es.getAddonPath('flashfun') + '/flashfun_config.ini')

# this will be our addon's Perfix for all the messages
prefix = '#green[#lightgreenFlashFun#green]'

# player database to store player information/players themselves
player = {}

''' FlashFun player-database class '''

class FlashFun:
    def __init__(self, userid):
        self.userid = userid
        self.roundkills = 0
    def spawn(self):
        self.roundkills = 0
        self.strip()
    def strip(self):
        es.setplayerprop(self.userid, 'CBasePlayer.m_iHealth', self.roundkills + 1)
        es.server.queuecmd('es_xfire %s func_bomb_target Disable;es_xfire %s func_hostage_rescue Disable;es_xfire %s func_buyzone Disable' % (self.userid, self.userid, self.userid))
        es.server.queuecmd('es_xfire %s player_weaponstrip kill' % self.userid)
        es.server.queuecmd('es_xgive %s player_weaponstrip' % self.userid)
        es.server.queuecmd('es_xfire %s player_weaponstrip strip' % self.userid)
        if int(config['knife']):
            es.server.queuecmd('es_xgive %s weapon_knife' % self.userid)
        gamethread.delayed(0, self.give)
    def give(self):
        weapon = config['weapon']
        if len(weapon) == 2:
            weapon = random.choice(weapon)
        es.server.queuecmd('es_xgive %s weapon_%s' % (self.userid, weapon))
    def addKill(self):
        self.roundkills += 1
        if self.roundkills in [1, 5, 15, 20, 35, 50, 100]:
            rk = 'Round-Kills'
            if self.roundkills == 1:
                rk = 'Round-Kill'
            es.msg('#multi', prefix, '#defaultPlayer #lightgreen%s #defaulthas #green%s #lightgreen%s #default=> #green%s #lightgreenHP' % (es.getplayername(self.userid), self.roundkills, rk, self.roundkills + 1))
    def removeKill(self):
        health = es.getplayerprop(self.userid, 'CBasePlayer.m_iHealth')
        if int(health):
            self.roundkills -= 1
            self.strip()
            es.tell(self.userid, '#multi', prefix, '#defaultLost one #lightgreenRound-Kill #default=> #green%s #lightgreenHP' % health)

''' Game and EventScripts Events '''

# -----------------
# Set server variable "flashfun_ver" to "2.0 ESP",
# call the reset function
# -----------------
def load():
    es.ServerVar('flashfun_ver', '2.0 ESP').makepublic()
    reset(_load=True)

# -----------------
# Call the reset function on every round start again
# -----------------
def round_start(ev):
    reset()

# -----------------
# Add the connecting player to our player database
# -----------------
def player_activate(ev):
    userid = ev['userid']
    player[userid] = FlashFun(userid)
    if botping and ev['es_steamid'] == 'BOT':
        setPing(userid)

# -----------------
# Strip the player off his/her weapons, set his/her HP to 1 and give him/her the weapon "flashbang"
# -----------------
def player_spawn(ev):
    userid = ev['userid']
    if int(ev['es_userteam']) > 1 and player.has_key(userid):
        player[userid].spawn()

# -----------------
# Strip the player off his/her weapons again, remove the smoke that's coming up from the thrown smokegrenade // thanks to Satoon for that!
# -----------------
def flashbang_detonate(ev):
    player[ev['userid']].strip()

def smokegrenade_detonate(ev):
    player[ev['userid']].strip()
    for index in es.createentitylist('env_particlesmokegrenade'):
        es.server.queuecmd('es_xremove %s' % index)

# -----------------
# Unblind the blinded player after a tick
# -----------------
def player_blind(ev):
    for x in ('CCSPlayer.m_flFlashFlpha', 'CCSPlayer.m_flFlashDuration'):
        es.setplayerprop(ev['userid'], x, 0)

# -----------------
# Remove a Round-Kill and a health point from the player that got hurt
# -----------------
def player_hurt(ev):
    player[ev['userid']].removeKill()

# -----------------
# If deathmatch-mode is enabled in the config file, remove dead players from the floor,
# remove idle weapons and respawn the player that died
# -----------------
def player_death(ev):
    userid = ev['userid']
    dm = config['deathmatch']
    if int(dm['deathmatch_enable']):
        weapon = ev['weapon']
        resp = 0
        if weapon == 'knife':
            resp = float(dm['knife_respawn'])
        else:
            resp = float(dm['respawn_player'])
        if es.exists('variable', 'nativetools_ver'):
            gamethread.delayed(resp, spawnPlayer, userid)
        elif es.exists('variable', 'est_version'):
            es.delayed(resp, 'est_Spawn %s 1' % userid)
        gamethread.delayed(float(dm['remove_ragdolls']), removeRagdolls)
        gamethread.delayed(float(dm['remove_weapons']), removeWeapons)
    player[ev['attacker']].addKill()

# -----------------
# Remove the disconnecting player from our player database
# -----------------
def player_disconnect(ev):
    userid = ev['userid']
    if player.has_key(userid):
        del player[userid]
    if botping and ev['networkid'] == 'BOT':
        gamethread.cancelDelayed(userid)

# -----------------
# Remove all the players from our player database on unload
# -----------------
def unload():
    player.clear()
    for userid in es.getUseridList():
        es.server.queuecmd('es_xfire %s func_bomb_target Enable;es_xfire %s func_buyzone Enable;es_xfire %s func_hostage_rescue Enable' % (userid, userid, userid))
        if es.getplayersteamid(userid) == 'BOT':
            gamethread.cancelDelayed(str(userid))

''' Event-related Functions '''

# -----------------
# Remove idle weapons and bodies
# -----------------
def removeWeapons():
    entlist = es.createentitylist()
    for index in entlist:
        if entlist[index]['classname'].startswith('weapon_') and es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == -1:
            es.server.queuecmd('es_xremove %s' % index)

def removeRagdolls():
    entlist = es.createentitylist('cs_ragdoll')
    for index in entlist:
        es.server.queuecmd('ent_remove %s' % index)

# -----------------
# Get the configured "botping" variable in the configuration file
# So admins can change the setting on-the-fly and don't have to
# reload the whole script
# -----------------
def botping():
    return int(config['botping'])

# -----------------
# Reset function - Add players to the database and set the bots' pings if configured in the configuration file
# -----------------
def reset(_load=False):
    for userid in es.getUseridList():
        uid = str(userid)
        if not player.has_key(uid):
            player[uid] = FlashFun(uid)
        player[uid].roundkills = 0
        player[uid].strip()
        if botping and _load and es.getplayersteamid(uid) == 'BOT':
            gamethread.cancelDelayed(uid)
            setPing(uid)

# -----------------
# If true in configuraion file, set the connecting bot's ping
# -----------------
def setPing(userid):
    if not es.exists('userid', userid):
        return
    es.setindexprop(es.getentityindex('cs_player_manager'), 'CPlayerResource.m_iPing.%03d' % getPlayer(userid).get('index'), random.randint(50, 80))
    gamethread.delayedname(4, userid, setPing, userid)
