#LandMines by Rennnyyy
#
#

import es
import math
import gamethread
import playerlib
import cfglib

#config

config = cfglib.AddonCFG(es.getAddonPath("../../cfg") + "/landmines/landmines.cfg")

config.text("LandMines by Rennnyyy")
config.text("LandMines Settings")
config.text("******************************")


lmText          = config.cvar('lmText','!mine','What to say to plant a mine?')

lmAmount        = config.cvar('lmAmount',   5,'How many mines can a player plant? 0 = unlimited amount')

lmDetonateRange = config.cvar('lmDetonateRange',   100, 'How near must a player come a mine until it detonates?')

lmDamageRange   = config.cvar('lmDamageRange', 300, 'How far does a mine damage?')

lmMineDamage    = config.cvar('lmMineDamage', 200, 'How many damage does a mine do?')

lmDamageTeam    = config.cvar('lmDamageTeam',   1, 'Does a mine also damage the team that it planted?')

lmCheckTime     = config.cvar('lmCheckTime',   0.1, 'How often does the script check if somebody stand on a mine? Only change, if you server lags!')

#end config

config.write()

lmMineList = {}
lmTMineList = {}
lmTMineXPositions = []
lmTMineYPositions = []
lmTMineZPositions = []
lmCTMineXPositions = []
lmCTMineYPositions = []
lmCTMineZPositions = []
lmPlayerDistance = []

def load():
    config.execute()
    es.msg('#multi', '#green[LandMines]#default have been loaded')
    
def unload():
    es.msg('#multi', '#green[LandMines]#default have been unloaded')

def player_say(ev):
    global lmMineList
    lmAlive = es.getplayerprop(ev['userid'], 'CCSPlayer.baseclass.pl.deadflag')
    if ev['text'] == lmText and lmAlive == 0:
        if lmAmount > 0:
            lmUserAmount = lmMineList[ev['userid']]
            if lmUserAmount > 0:
                lmMineList[ev['userid']] = lmUserAmount - 1
                lmX, lmY, lmZ = es.getplayerlocation(ev['userid'])
                plantMine(lmX, lmY, lmZ, ev['userid'], es.getplayerteam(ev['userid']))
            else:
                es.tell(ev['userid'], '#multi', '#green[LandMine]#default You can not plant a mine anymore')
        else:
            lmX, lmY, lmZ = es.getplayerlocation(ev['userid'])
            plantMine(lmX, lmY, lmZ, ev['userid'], es.getplayerteam(ev['userid']))
    elif lmAlive == 1 and ev['text'] == lmText:
        es.tell(ev['userid'], '#multi', '#green[LandMine]#default Dead can not plant mines')
        
def player_spawn(ev):
    global zl,MineList
    if lmAmount > 0:
        lmMineList[ev['userid']] = lmAmount

def round_start(ev):
    global lmRoundRuns
    lmRoundRuns = 1
    checkCTMines()
    checkTMines()
    showCTMines()
    showTMines()
    
def round_end(ev):
    global lmRoundRuns, lmTMineXPositions, lmTMineYPositions, lmTMineZPositions, lmCTMineXPositions, lmCTMineYPositions, lmCTMineZPositions
    lmRoundRuns = 0
    del lmTMineXPositions[:]
    del lmTMineYPositions[:]
    del lmTMineZPositions[:]
    del lmCTMineXPositions[:]
    del lmCTMineYPositions[:]
    del lmCTMineZPositions[:]
    
def plantMine(x, y, z, userid, team):
    global lmTMineXPositions, lmTMineYPositions, lmTMineZPositions, lmCTMineXPositions, lmCTMineYPositions, lmCTMineZPositions
    es.tell(userid, '#multi', '#green[LandMine]#default has been planted')
    if team == 2:
        lmTMineXPositions.append(x)
        lmTMineYPositions.append(y)
        lmTMineZPositions.append(z)
    elif team == 3:
        lmCTMineXPositions.append(x)
        lmCTMineYPositions.append(y)
        lmCTMineZPositions.append(z)
    
def checkCTMines():
    lmTList = playerlib.getUseridList('#t')
    for i in range(0, len(lmCTMineXPositions)):
        del lmPlayerDistance[:]
        lmMX = lmCTMineXPositions[i]
        lmMY = lmCTMineYPositions[i]
        lmMZ = lmCTMineZPositions[i]
        for j in range(0, len(lmTList)):
            lmPX, lmPY, lmPZ = es.getplayerlocation(lmTList[j])
            lmCX = lmPX - lmMX
            lmCY = lmPY - lmMY
            lmCZ = lmPZ - lmMZ
            lmDistance = math.sqrt(lmCX*lmCX + lmCY*lmCY + lmCZ*lmCZ)
            lmPlayerDistance.append(lmDistance)
        for k in range(0, len(lmPlayerDistance)):
            if lmPlayerDistance[k] < lmDetonateRange:
                lmUserid = lmTList[k]
                del lmCTMineXPositions[i]
                del lmCTMineYPositions[i]
                del lmCTMineZPositions[i]
                if lmDamageTeam == 0:
                    es.server.queuecmd('est_god #c 1')
                    gamethread.delayed(.1, hurtableCT)
                es.server.queuecmd('es_xgive %s env_explosion' % (lmUserid))
                es.server.queuecmd('es_xfire %s env_explosion AddOutput "iMagnitude %s"' % (lmUserid, lmMineDamage))
                es.server.queuecmd('es_xfire %s env_explosion AddOutput "iRadiusOverride %s"' % (lmUserid, lmDamageRange))
                es.server.queuecmd('es_xfire %s env_explosion CBaseEntity.m_vecOrigin %s %s %s' % (lmUserid, lmMX, lmMY, lmMZ + 5))
                es.server.queuecmd('es_xfire %s env_explosion explode' % (lmUserid))
                k = k + 1000
    gamethread.delayed(lmCheckTime, checkCTMines)
    
def checkTMines():
    lmCTList = playerlib.getUseridList('#ct')
    for i in range(0, len(lmTMineXPositions)):
        del lmPlayerDistance[:]
        lmMX = lmTMineXPositions[i]
        lmMY = lmTMineYPositions[i]
        lmMZ = lmTMineZPositions[i]
        for j in range(0, len(lmCTList)):
            lmPX, lmPY, lmPZ = es.getplayerlocation(lmCTList[j])
            lmCX = lmPX - lmMX
            lmCY = lmPY - lmMY
            lmCZ = lmPZ - lmMZ
            lmDistance = math.sqrt(lmCX*lmCX + lmCY*lmCY + lmCZ*lmCZ)
            lmPlayerDistance.append(lmDistance)
        for k in range(0, len(lmPlayerDistance)):
            if lmPlayerDistance[k] < lmDetonateRange:
                lmUserid = lmCTList[k]
                del lmTMineXPositions[i]
                del lmTMineYPositions[i]
                del lmTMineZPositions[i]
                if lmDamageTeam == 0:
                    es.server.queuecmd('est_god #t 1')
                    gamethread.delayed(.1, hurtableT)
                es.server.queuecmd('es_xgive %s env_explosion' % (lmUserid))
                es.server.queuecmd('es_xfire %s env_explosion AddOutput "iMagnitude %s"' % (lmUserid, lmMineDamage))
                es.server.queuecmd('es_xfire %s env_explosion AddOutput "iRadiusOverride %s"' % (lmUserid, lmDamageRange))
                es.server.queuecmd('es_xfire %s env_explosion CBaseEntity.m_vecOrigin %s %s %s' % (lmUserid, lmMX, lmMY, lmMZ + 5))
                es.server.queuecmd('es_xfire %s env_explosion explode' % (lmUserid))
                k = k + 1000
    gamethread.delayed(lmCheckTime, checkTMines)
    
def showCTMines():
    if lmRoundRuns == 1:
        for i in range (0, len(lmCTMineXPositions)):
            lmMX = lmCTMineXPositions[i]
            lmMY = lmCTMineYPositions[i]
            lmMZ = lmCTMineZPositions[i]
            es.server.queuecmd('est_effect 10 #c 0 "sprites/lgtning.vmt" %s %s %s 1 %s 1 10 50 0 255 0 0 200 0' % (lmMX, lmMY, lmMZ, lmDetonateRange))
        gamethread.delayed(1, showCTMines)
        
def showTMines():
    if lmRoundRuns == 1:
        for i in range (0, len(lmTMineXPositions)):
            lmMX = lmTMineXPositions[i]
            lmMY = lmTMineYPositions[i]
            lmMZ = lmTMineZPositions[i]
            es.server.queuecmd('est_effect 10 #t 0 "sprites/lgtning.vmt" %s %s %s 1 %s 1 10 50 0 255 0 0 200 0' % (lmMX, lmMY, lmMZ, lmDetonateRange))
        gamethread.delayed(1, showTMines)
        
def hurtableCT():
    es.server.queuecmd('est_god #c 0')
    
def hurtableT():
    es.server.queuecmd('est_god #t 0')
